/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityLoader;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityInventoryProvider;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;

public class TileEntityItemLoader
extends ATileEntityLoader
implements ITileEntityInventoryProvider {
    private final EntityInventoryContainer inventory;
    private static final int LOADING_RATE = 10;

    public TileEntityItemLoader(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
        this.inventory = new EntityInventoryContainer(world, data != null ? data.getData("inventory") : null, (int)(((JSONDecor)this.definition).decor.inventoryUnits * 9.0f));
        world.addEntity(this.inventory);
    }

    @Override
    public void update() {
        block3: {
            block4: {
                super.update();
                if (!this.isUnloader()) break block4;
                if ((this.ticksExisted + 1L) % 10L != 0L) break block3;
                for (int i = 0; i < this.inventory.getSize(); ++i) {
                    IWrapperItemStack stack = this.inventory.getStack(i);
                    if (stack.isEmpty() || !this.world.insertStack(this.position, ABlockBase.Axis.DOWN, stack)) continue;
                    this.inventory.setStack(stack, i);
                    break block3;
                }
                break block3;
            }
            if ((this.ticksExisted - 1L) % 10L == 0L) {
                for (int i = 0; i < this.inventory.getSize(); ++i) {
                    IWrapperItemStack extractedStack;
                    IWrapperItemStack stack = this.inventory.getStack(i);
                    if (!stack.isEmpty() || (extractedStack = this.world.extractStack(this.position, ABlockBase.Axis.UP)) == null) continue;
                    stack = extractedStack;
                    this.inventory.setStack(stack, i);
                    break;
                }
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.inventory.remove();
    }

    @Override
    public boolean isUnloader() {
        return ((JSONDecor)this.definition).decor.type.equals((Object)JSONDecor.DecorComponentType.ITEM_UNLOADER);
    }

    @Override
    protected boolean canOperate() {
        return this.isUnloader() ? this.inventory.getStackCount() < this.inventory.getSize() : this.inventory.getStackCount() > 0;
    }

    @Override
    protected boolean canLoadPart(PartInteractable part) {
        if (part.inventory != null) {
            if (this.isUnloader()) {
                return true;
            }
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                IWrapperItemStack stack = this.inventory.getStack(i);
                if (stack.isEmpty() || !part.inventory.addStack(stack, 1, false)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void doLoading() {
        if (this.ticksExisted % 10L == 0L) {
            boolean hadStacksToAddThisCheck = false;
            boolean addedStacksThisCheck = false;
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                IWrapperItemStack stack = this.inventory.getStack(i);
                if (stack.isEmpty() || addedStacksThisCheck) continue;
                hadStacksToAddThisCheck = true;
                if (!this.connectedPart.inventory.addStack(stack, 1, true)) continue;
                this.inventory.setStack(stack, i);
                addedStacksThisCheck = true;
                break;
            }
            if (hadStacksToAddThisCheck && !addedStacksThisCheck) {
                this.updateNearestPart();
            }
        }
    }

    @Override
    protected void doUnloading() {
        if (this.ticksExisted % 10L == 0L) {
            boolean hadStacksToRemoveThisCheck = false;
            for (int i = 0; i < this.connectedPart.inventory.getSize(); ++i) {
                IWrapperItemStack stack = this.connectedPart.inventory.getStack(i);
                if (stack.isEmpty()) continue;
                hadStacksToRemoveThisCheck = true;
                if (!this.inventory.addStack(stack, 1, true)) continue;
                this.connectedPart.inventory.setStack(stack, i);
                break;
            }
            if (!hadStacksToRemoveThisCheck) {
                this.updateNearestPart();
            }
        }
    }

    @Override
    public EntityInventoryContainer getInventory() {
        return this.inventory;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setData("inventory", this.inventory.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        return data;
    }
}

